/*:
 * @plugindesc BlackGirlQuest layout.
 * @author TRS
 *
 */

/*:ja
 * @plugindesc 黒ギャルクエストでのプラグイン全般（※YED_SideviewBattlersとTmSoloStatusが必要です。その下に配置してください）
 * @author TRS
 *
 *
 * @param ----メニュー画面のアニメ設定-----
 * @desc セパレータ 
 `
 * @param 枚数
 * @desc メニュー画面でのアニメーション最大数
 * @type number
 * @max 25
 * @min 1
 * @default 15
 *
 * @param 切り替え時間
 * @desc メニュー画面での１枚の表示間隔
 * @type number
 * @max 100
 * @min 1
 * @default 4
 *
 * @param 横位置
 * @desc 配置する横座標(左上原点)
 * @type number
 * @max 1200
 * @min -1200
 * default 80
 *
 * @param 縦位置
 * @desc 配置する縦座標(左上原点)
 * @type number
 * @max 700
 * @min -700
 * default 105
 *
 * @param オナニーチェックSW
 * @desc 並列オナニーチェックSW
 * @type switch
 * @default 
 *
 * @help
 *
 * 敵のメモ欄に以下の項目を設定することで指定した影をつけれます
 * ※未設定時は影をつけません
 * ※影ファイルの画像はサイドビュー戦闘ならsv_enemies、フロントビュー戦闘ならenemiesに置く必要があります
 *
 * <shadows:(影ファイル画像), (オフセットX座標), (オフセットY座標)>
 * 
 * 使用例
 * <shadows:クモ男影,10,-50>
 * クモ男影を、敵画像（中心下原点）から10pix右、50pix上に表示
 */

(function() 
{

	var parameters = PluginManager.parameters('BlackGirlQuest');
	var Params = {};
	Params.frames = Number( parameters['枚数'] || 15);
	Params.delay = Number( parameters['切り替え時間'] || 4);
	Params.Xpos = Number( parameters['横位置'] || 80);
	Params.Ypos = Number( parameters['縦位置'] || 105);
	
	/**
	 * YED_SideviewBattlersのgetSideviewFilenameの上書き
	 */
	
	Game_Actor.prototype.getSideviewFilename = function()
	{
		return $gameActors.actor(1)._battlerName;
	}
	
	/**
	 * ソロメニューの初期設定
	 */
	var _window_SoloStatus_prototype_initialize = Window_SoloStatus.prototype.initialize;
	Window_SoloStatus.prototype.initialize = function()
	{
		_window_SoloStatus_prototype_initialize.call(this);
		
		this.varAnimeCnt = 0;
		this.varIndex = 1;
		this.bitmap = null;
		
		this.preLoadStandAnime();
	}
	
	/**
	 * ソロメニューステータス
	 */
	var _window_soloStatus_prototype_update = Window_SoloStatus.prototype.update;
	Window_SoloStatus.prototype.update = function()
	{
		_window_soloStatus_prototype_update.call(this);
		this.refresh();
		
	}
	
	var _window_SoloStatus_prototype_refresh = Window_SoloStatus.prototype.refresh;
	Window_SoloStatus.prototype.refresh = function( )
	{
		_window_SoloStatus_prototype_refresh.call(this);
		this.SoloStatusStandAnime();
	}
	
	/**
	 * メニューアニメ絵のプリロード
	 */
	Window_SoloStatus.prototype.preLoadStandAnime = function()
	{
		var tekitouFileName = $gameActors.actor(1)._faceName;
		
		for(var i = 1; i <= Params.frames; i++)
		{
			var wrk = tekitouFileName + '_' + ('00' + i).slice(-2);	//0埋め
			this.bltImage(wrk);
		}
	}
	
	/**
	 *　アニメ切り替え
	 */
	Window_SoloStatus.prototype.SoloStatusStandAnime = function()
	{
		var tekitouFileName = $gameActors.actor(1)._faceName;
		
		this.varAnimeCnt++;
		if( this.varIndex < Params.frames)
		{
			if( this.varAnimeCnt % Params.delay === 0)
			{
				this.varIndex++;
			}
		}
		else
		{
			this.varIndex = 1;
			varAnimeCnt = 0;
		}
		
		tekitouFileName += '_' + ('00' + this.varIndex).slice(-2);	//0埋め
		this.bltImage(tekitouFileName);
	}
	
	Window_SoloStatus.prototype.bltImage = function( varFileName )
	{
		
		//this.contents.clear();
		this.bitmap = ImageManager.loadPicture( varFileName );
		var pw = this.bitmap._image.width;
		var ph = this.bitmap._image.height;
		var sx = 0;
		var sy = 0;
		var x = Params.Xpos;
		var y = Params.Ypos;
		
		this.contents.blt(this.bitmap, sx, sy, pw, ph, x, y);
	}
	
	
	Game_Enemy.prototype.performDamage = function() 
	{
    	Game_Battler.prototype.performDamage.call(this);
    	SoundManager.playEnemyDamage();
    	this.requestEffect('blink');
	};
	
	//--------------------------------------------------
	//   Sprite_Enemy上書き Spriteset_Base
	//
	var _sprite_enemy_prototype_initMembers = Sprite_Enemy.prototype.initMembers;
	Sprite_Enemy.prototype.initMembers = function() 
	{
	    _sprite_enemy_prototype_initMembers.call(this);
	    this._initUpdate = false;
	    this.createShadowSprite();
	    //this.hudSprite();				//自分のグラ追加
	    
	};
	
	/**
	 * 影スプライトの作成と登録
	 */
	Sprite_Enemy.prototype.createShadowSprite = function()
	{
		this._shadowSprite = new Sprite_Shadow();
		this.addChild( this._shadowSprite );
		
	}
	
	/**
	 * hudスプライトの作成と登録
	 */
	Sprite_Enemy.prototype.createhudSprite = function()
	{
		this._hudSprite = new Sprite();
		this.addChild( this._hudSprite );
		
	}
	
	//バトラーセット
	var _sprite_enemy_prototype_setBattler = Sprite_Enemy.prototype.setBattler;
	Sprite_Enemy.prototype.setBattler = function(battler)
	{
    	_sprite_enemy_prototype_setBattler.call(this, battler);
    	this._shadowSprite.setup(battler);
	};

	var _sprite_Enemy_prototype_updateBitmap = Sprite_Enemy.prototype.updateBitmap;
	Sprite_Enemy.prototype.updateBitmap = function() 
	{
		_sprite_Enemy_prototype_updateBitmap.call(this);
		
		
		//console.log(SceneManager._scene._spriteset);
		
	   //Sprite_Battler.prototype.updateBitmap.call(this);
	   // var name = this._enemy.battlerName();
	    //var hue = this._enemy.battlerHue();
	    //if (this._battlerName !== name || this._battlerHue !== hue) {
	    //    this._battlerName = name;
	    //    this._battlerHue = hue;
	    //    this.loadBitmap(name, hue);
	    //    this.initVisibility();
	    //}
	    //this.z = 5;
	    
	    //this.hudSpriteUpdate()

	    //console.log( this );
	};
	
	/**
	 * Hudスプライト更新
	 */
	 Sprite_Enemy.prototype.hudSpriteUpdate = function()
	 {
	 	this._hudSprite.bitmap = this.bitmap;
	 }
	 
	//-----------------------------------------------------------------------------
	// Sprite_Shadow
	//
	function Sprite_Shadow() {
	    this.initialize.apply(this, arguments);
	}

	Sprite_Shadow.prototype = Object.create(Sprite.prototype);
	Sprite_Shadow.prototype.constructor = Sprite_Shadow;

	Sprite_Shadow.prototype.initialize = function() {
	    Sprite.prototype.initialize.call(this);
	    this.initMembers();
	};
	
	Sprite_Shadow.prototype.initMembers = function() {
	    this._battler = null;
	    this.anchor.x = 0.5;
	    this.anchor.y = 1;
	    
	    this._offsetX = 0;
	    this._offsetY = 0;
	};
	
	/**
	 * 読み込み
	 */
	Sprite_Shadow.prototype.loadBitmap = function( name ) 
	{
		if ( $gameSystem.isSideView() ) 
		{
	        this.bitmap = ImageManager.loadSvEnemy( name, 0);
	    } else {
	        this.bitmap = ImageManager.loadEnemy( name, 0);
	    }
		
	};
	
	/**
	 * バトラー情報保持
	 */
	Sprite_Shadow.prototype.setup = function(battler) {
	    this._battler = battler;
	    
	};
	
	/**
	 * 更新時
	 */
	Sprite_Shadow.prototype.update = function() {
	    Sprite.prototype.update.call(this);
	    this.updateShadow();
	    
	};
	
	/**
	 * 更新時の影出し判断
	 */
	Sprite_Shadow.prototype.updateShadow = function() 
	{
		if( $dataEnemies[ this._battler._enemyId ].meta["shadows"] !== undefined )
		{
			varSpritWrk = ($dataEnemies[ this._battler._enemyId ].meta["shadows"]).split(',');
			
			if(varSpritWrk[0].replace(' ') !== '' )
			{
				this.loadBitmap( varSpritWrk[0] );
				this.updateFrame();
				//console.log( this );
				
				this._offsetX = Number( varSpritWrk[1] );
				this._offsetY = Number( varSpritWrk[2] );
	    	}
	   }
	};
	
	Sprite_Shadow.prototype.updateFrame = function() 
	{
		var pw = this.bitmap.width;
		var ph = this.bitmap.height;
		var sx = 0;
		var sy = 0;
		this.setFrame(sx, sy, pw, ph);
    
	    this.x = this._offsetX;
	    this.y = this._offsetY;
	};

	//--------------------------------------------------
	//   GameActor上書き
	//
	
	/*var game_actor_prototype_performDamage = Game_Actor.prototype.performDamage;
	Game_Actor.prototype.performDamage = function() 
	{
    	Game_Battler.prototype.performDamage.call(this);
    if (this.isSpriteVisible()) {
        this.requestMotion('damage');
    } else {
        $gameScreen.startShake(5, 5, 10);
    }
    SoundManager.playActorDamage();
	};*/
	
})();